// ==UserScript==
// @name         Auto Copy Selected Text
// @namespace    http://tampermonkey.net/
// @version      1.0
// @description  Automatically copy selected text to clipboard
// @author       YourName
// @match        https://docs.djangoproject.com
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    document.addEventListener('mouseup', function() {
        var selectedText = window.getSelection().toString().trim();
        if (selectedText.length > 0) {
            var textarea = document.createElement("textarea");
            textarea.style.position = 'fixed';
            textarea.style.opacity = '0';
            textarea.value = selectedText;
            document.body.appendChild(textarea);
            textarea.select();
            try {
                document.execCommand('copy');
                console.log('Text copied to clipboard: ', selectedText);
            } catch (err) {
                console.error('Failed to copy text: ', err);
            }
            document.body.removeChild(textarea);
        }
    });
})();
